<?php

namespace RomethemeKit;

use RomeTheme;
use RomethemePro;

class RkitWidgets
{

    private $list_widgets;

    public function __construct()
    {

        $this->update_widget_option();
        add_action('elementor/widgets/register', [$this, 'register_widget']);
        // add_action('elementor/widgets/register', [$this, 'register_widget_pro']);
        add_action('admin_enqueue_scripts', [$this, 'register_style']);
        // add_action('elementor/editor/before_enqueue_scripts', [$this, 'pro_js']);
        add_action('wp_ajax_save_options', [$this, 'save_options']);
    }

    private function update_widget_option()
    {
        $options = get_option('rkit-widget-options');
        $optionsPro = get_option('rkit-widget-pro-options');

        if ($options == false) {
            $this->list_widgets = [
                'offcanvas' => [
                    'name' => 'Offcanvas',
                    'icon' => 'rtmicon rtmicon-header-offcanvas',
                    'class_name' => 'Offcanvas_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'search' => [
                    'name' => 'Search',
                    'icon' => 'rtmicon rtmicon-search',
                    'class_name' => 'Search_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'sitelogo' => [
                    'name' => 'Site Logo',
                    'icon' => 'rtmicon rtmicon-site-logo',
                    'class_name' => 'SiteLogo_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'headerinfo' => [
                    'name' => 'Header Info',
                    'icon' => 'rtmicon rtmicon-header-info',
                    'class_name' => 'HeaderInfo_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'navmenu' => [
                    'name' => 'Nav Menu',
                    'icon' => 'rtmicon rtmicon-nav-menu',
                    'class_name' => 'Nav_Menu_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'blogpost' => [
                    'name' => 'Blog Post',
                    'icon' => 'rtmicon rtmicon-blog',
                    'class_name' => 'Blog_Post_Rkit',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'cta' => [
                    'name' => 'Call To Action',
                    'icon' => 'rtmicon rtmicon-call-to-action',
                    'class_name' => 'CTA_Rkit',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'blockquote' => [
                    'name' => 'Blockquote',
                    'icon' => 'rtmicon rtmicon-blockquote',
                    'class_name' => 'Rkit_BLockQuote',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'socialshare' => [
                    'name' => 'Social Share',
                    'icon' => 'rtmicon rtmicon-social-share',
                    'class_name' => 'Rkit_SocialShare',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'team' => [
                    'name' => 'Team',
                    'icon' => 'rtmicon rtmicon-team',
                    'class_name' => 'Rkit_Team',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'runningtext' => [
                    'name' => 'Text Marquee',
                    'icon' => 'rtmicon rtmicon-text-marquee',
                    'class_name' => 'Rkit_RunningText',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'animatedheading' => [
                    'name' => 'Animated Heading',
                    'icon' => 'eicon-animation-text',
                    'class_name' => 'Rkit_AnimatedHeading',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'cardslider' => [
                    'name' => 'Card Slider',
                    'icon' => 'rtmicon rtmicon-content-slider',
                    'class_name' => 'Rkit_CardSlider',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'accordion' => [
                    'name' => 'Accordion',
                    'icon' => 'eicon-accordion',
                    'class_name' => 'Rkit_Accordion',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'barchart' => [
                    'name' => 'Bar Chart',
                    'icon' => 'rtmicon rtmicon-graphic-bar',
                    'class_name' => 'Rkit_BarChart',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'linechart' => [
                    'name' => 'Line Chart',
                    'icon' => 'rtmicon rtmicon-chart-line-up',
                    'class_name' => 'Rkit_LineChart',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'piechart' => [
                    'name' => 'Pie Chart',
                    'icon' => 'rtmicon rtmicon-pie-chart',
                    'class_name' => 'Rkit_PieChart',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'testimonialcarousel' => [
                    'name' => 'Testimonial Carousel',
                    'icon' => 'rtmicon rtmicon-testimonial-carousel',
                    'class_name' => 'Rkit_TestimonialCarousel',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'tabs' => [
                    'name' => 'Tabs',
                    'icon' => 'eicon-tabs',
                    'class_name' => 'Rkit_Tabs',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'progressbar' => [
                    'name' => 'Progress Bar',
                    'icon' => 'rtmicon rtmicon-Horizontal-progress-bar',
                    'class_name' => 'Rkit_ProgressBar',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'counter' => [
                    'name' => 'Counter',
                    'icon' => 'rtmicon rtmicon-counters',
                    'class_name' => 'Rkit_Counter',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
            ];
            update_option('rkit-widget-options', $this->list_widgets);
        } else {
            $update_icon = [
                'offcanvas' => [
                    'name' => 'Offcanvas',
                    'icon' => 'rtmicon rtmicon-header-offcanvas',
                    'class_name' => 'Offcanvas_Rometheme',
                    'category' => 'header',
                    'type' => 'free'
                ],
                'search' => [
                    'name' => 'Search',
                    'icon' => 'rtmicon rtmicon-search',
                    'class_name' => 'Search_Rometheme',
                    'category' => 'header',
                    'type' => 'free'
                ],
                'sitelogo' => [
                    'name' => 'Site Logo',
                    'icon' => 'rtmicon rtmicon-site-logo',
                    'class_name' => 'SiteLogo_Rometheme',
                    'category' => 'header',
                    'type' => 'free'
                ],
                'headerinfo' => [
                    'name' => 'Header Info',
                    'icon' => 'rtmicon rtmicon-header-info',
                    'class_name' => 'HeaderInfo_Rometheme',
                    'category' => 'header',
                    'type' => 'free'
                ],
                'navmenu' => [
                    'name' => 'Nav Menu',
                    'icon' => 'rtmicon rtmicon-nav-menu',
                    'class_name' => 'Nav_Menu_Rometheme',
                    'category' => 'header',
                    'type' => 'free'
                ],
                'blogpost' => [
                    'name' => 'Blog Post',
                    'icon' => 'rtmicon rtmicon-blog',
                    'class_name' => 'Blog_Post_Rkit',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'cta' => [
                    'name' => 'Call To Action',
                    'icon' => 'rtmicon rtmicon-call-to-action',
                    'class_name' => 'CTA_Rkit',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'blockquote' => [
                    'name' => 'Blockquote',
                    'icon' => 'rtmicon rtmicon-blockquote',
                    'class_name' => 'Rkit_BLockQuote',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'socialshare' => [
                    'name' => 'Social Share',
                    'icon' => 'rtmicon rtmicon-social-share',
                    'class_name' => 'Rkit_SocialShare',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'team' => [
                    'name' => 'Team',
                    'icon' => 'rtmicon rtmicon-team',
                    'class_name' => 'Rkit_Team',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'runningtext' => [
                    'name' => 'Text Marquee',
                    'icon' => 'rtmicon rtmicon-text-marquee',
                    'class_name' => 'Rkit_RunningText',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'animatedheading' => [
                    'name' => 'Animated Heading',
                    'icon' => 'eicon-animation-text',
                    'class_name' => 'Rkit_AnimatedHeading',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'cardslider' => [
                    'name' => 'Card Slider',
                    'icon' => 'rtmicon rtmicon-content-slider',
                    'class_name' => 'Rkit_CardSlider',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'accordion' => [
                    'name' => 'Accordion',
                    'icon' => 'eicon-accordion',
                    'class_name' => 'Rkit_Accordion',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'barchart' => [
                    'name' => 'Bar Chart',
                    'icon' => 'rtmicon rtmicon-graphic-bar',
                    'class_name' => 'Rkit_BarChart',
                    'category' => 'rkit',
                    'type' => 'pro'
                ],
                'linechart' => [
                    'name' => 'Line Chart',
                    'icon' => 'rtmicon rtmicon-chart-line-up',
                    'class_name' => 'Rkit_LineChart',
                    'category' => 'rkit',
                    'type' => 'pro'
                ],
                'piechart' => [
                    'name' => 'Pie Chart',
                    'icon' => 'rtmicon rtmicon-pie-chart',
                    'class_name' => 'Rkit_PieChart',
                    'category' => 'rkit',
                    'type' => 'pro'
                ],
                'testimonialcarousel' => [
                    'name' => 'Testimonial Carousel',
                    'icon' => 'rtmicon rtmicon-testimonial-carousel',
                    'class_name' => 'Rkit_TestimonialCarousel',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'tabs' => [
                    'name' => 'Tabs',
                    'icon' => 'eicon-tabs',
                    'class_name' => 'Rkit_Tabs',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'progressbar' => [
                    'name' => 'Progress Bar',
                    'icon' => 'rtmicon rtmicon-horizon-progress-bar',
                    'class_name' => 'Rkit_ProgressBar',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
                'counter' => [
                    'name' => 'Counter',
                    'icon' => 'rtmicon rtmicon-counters',
                    'class_name' => 'Rkit_Counter',
                    'category' => 'rkit',
                    'type' => 'free'
                ],
            ];
           
            if (! self::compareArrays( $update_icon, $options, 'icon')) {
                $update_opt = $options;

                foreach ($update_icon as $key => $value) {
                    $update_opt[$key]['icon'] = $value['icon'];
                }
                update_option('rkit-widget-options' , $update_opt);
            }
            $this->list_widgets = [
                'offcanvas' => [
                    'name' => 'Offcanvas',
                    'icon' => 'rtmicon rtmicon-header-offcanvas',
                    'class_name' => 'Offcanvas_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'search' => [
                    'name' => 'Search',
                    'icon' => 'rtmicon rtmicon-search',
                    'class_name' => 'Search_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'sitelogo' => [
                    'name' => 'Site Logo',
                    'icon' => 'rtmicon rtmicon-site-logo',
                    'class_name' => 'SiteLogo_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'headerinfo' => [
                    'name' => 'Header Info',
                    'icon' => 'rtmicon rtmicon-header-info',
                    'class_name' => 'HeaderInfo_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'navmenu' => [
                    'name' => 'Nav Menu',
                    'icon' => 'rtmicon rtmicon-nav-menu',
                    'class_name' => 'Nav_Menu_Rometheme',
                    'category' => 'header',
                    'status' => true,
                    'type' => 'free'
                ],
                'blogpost' => [
                    'name' => 'Blog Post',
                    'icon' => 'rtmicon rtmicon-blog',
                    'class_name' => 'Blog_Post_Rkit',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'cta' => [
                    'name' => 'Call To Action',
                    'icon' => 'rtmicon rtmicon-call-to-action',
                    'class_name' => 'CTA_Rkit',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'blockquote' => [
                    'name' => 'Blockquote',
                    'icon' => 'rtmicon rtmicon-blockquote',
                    'class_name' => 'Rkit_BLockQuote',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'socialshare' => [
                    'name' => 'Social Share',
                    'icon' => 'rtmicon rtmicon-social-share',
                    'class_name' => 'Rkit_SocialShare',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'team' => [
                    'name' => 'Team',
                    'icon' => 'rtmicon rtmicon-team',
                    'class_name' => 'Rkit_Team',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'runningtext' => [
                    'name' => 'Text Marquee',
                    'icon' => 'rtmicon rtmicon-text-marquee',
                    'class_name' => 'Rkit_RunningText',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'animatedheading' => [
                    'name' => 'Animated Heading',
                    'icon' => 'eicon-animation-text',
                    'class_name' => 'Rkit_AnimatedHeading',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'cardslider' => [
                    'name' => 'Card Slider',
                    'icon' => 'rtmicon rtmicon-content-slider',
                    'class_name' => 'Rkit_CardSlider',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'accordion' => [
                    'name' => 'Accordion',
                    'icon' => 'eicon-accordion',
                    'class_name' => 'Rkit_Accordion',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'barchart' => [
                    'name' => 'Bar Chart',
                    'icon' => 'rtmicon rtmicon-graphic-bar',
                    'class_name' => 'Rkit_BarChart',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'linechart' => [
                    'name' => 'Line Chart',
                    'icon' => 'rtmicon rtmicon-chart-line-up',
                    'class_name' => 'Rkit_LineChart',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'piechart' => [
                    'name' => 'Pie Chart',
                    'icon' => 'rtmicon rtmicon-pie-chart',
                    'class_name' => 'Rkit_PieChart',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'testimonialcarousel' => [
                    'name' => 'Testimonial Carousel',
                    'icon' => 'rtmicon rtmicon-testimonial-carousel',
                    'class_name' => 'Rkit_TestimonialCarousel',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'tabs' => [
                    'name' => 'Tabs',
                    'icon' => 'eicon-tabs',
                    'class_name' => 'Rkit_Tabs',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'progressbar' => [
                    'name' => 'Progress Bar',
                    'icon' => 'rtmicon rtmicon-Horizontal-progress-bar',
                    'class_name' => 'Rkit_ProgressBar',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
                'counter' => [
                    'name' => 'Counter',
                    'icon' => 'rtmicon rtmicon-counters',
                    'class_name' => 'Rkit_Counter',
                    'category' => 'rkit',
                    'status' => true,
                    'type' => 'free'
                ],
            ];
           if (self::checkKey($options , 'status')) {
            update_option('rkit-widget-options' , $this->list_widgets);
           }
        }

        // $list_widgets_pro = [
        //     'cubeslider' => [
        //         'name' => 'Cube Slider',
        //         'icon' => 'rtmicon rtmicon-Counters',
        //         'class_name' => 'Rkit_CubeSlider',
        //         'category' => 'rkit_pro',
        //         'status' => true,
        //         'type' => 'pro'
        //     ],
        //     'barchart' => [
        //         'name' => 'Bar Chart',
        //         'icon' => 'rtmicon rtmicon-Graph-Bar',
        //         'class_name' => 'Rkit_BarChart',
        //         'category' => 'rkit_pro',
        //         'status' => true,
        //         'type' => 'pro'
        //     ],
        //     'linechart' => [
        //         'name' => 'Line Chart',
        //         'icon' => 'rtm-linechart-icons',
        //         'class_name' => 'Rkit_LineChart',
        //         'category' => 'rkit_pro',
        //         'status' => true,
        //         'type' => 'pro'
        //     ],
        //     'piechart' => [
        //         'name' => 'Pie Chart',
        //         'icon' => 'rtmicon rtmicon-Pie-Chart',
        //         'class_name' => 'Rkit_PieChart',
        //         'category' => 'rkit_pro',
        //         'status' => true,
        //         'type' => 'pro'
        //     ],
        // ];
        // foreach ($list_widgets_pro as $key => $value) {
        //     if (array_key_exists($key, $options)) {
        //         unset($options[$key]);
        //         update_option('rkit-widget-options', $options);
        //     }
        // }

        // if ($optionsPro == false) {
        //     update_option('rkit-widget-pro-options', $list_widgets_pro);
        // }
    }

    public static function register_widget($widgets_manager)
    {

        $widgets = scandir(\RomeTheme::widget_dir());
        $bs_widgets = scandir(\RomeTheme::widget_dir() . '/rkit_widgets');

        foreach ($widgets as $widget) {
            if (strpos($widget, '.php') !== false) {
                require_once(\RomeTheme::widget_dir() . $widget);
            }
        }

        foreach ($bs_widgets as $widget) {
            if (strpos($widget, '.php') !== false) {
                require_once(\RomeTheme::widget_dir() . 'rkit_widgets/' . $widget);
            }
        }

        $widget_lists = get_option('rkit-widget-options');

        foreach ($widget_lists as $widget) {
            if ($widget['status'] and $widget['type'] == 'free') {
                $widgets_manager->register(new $widget['class_name']());
            }
        }
    }

    function compareArrays($array1, $array2, $keyToCompare) {
        foreach ($array1 as $key => $value1) {
            if (!isset($array2[$key])) {
                return false; // Jika kunci tidak ditemukan di array kedua
            }
            
            if ($value1[$keyToCompare] !== $array2[$key][$keyToCompare]) {
                return false; // Jika nilai tidak sama
            }
        }
        
        return true; // Jika semua nilai sama
    }

    private function checkKey($array , $key) {
        foreach ($array as $obj) {
            if (!array_key_exists($key, $obj)) {
                return true; 
            }
        }
        return false; 
    }

    function register_style()
    {

        $screen = get_current_screen();
        if ($screen->id == 'romethemekit_page_rkit-widgets') {
            wp_enqueue_style('style', RomeTheme::module_url() . 'HeaderFooter/assets/css/style.css');
            wp_enqueue_script('widgetViewScript', RomeTheme::module_url() . 'widgets/assets/js/widget.js', ['jquery'], RomeTheme::rt_version());
            wp_localize_script('widgetViewScript', 'rometheme_ajax_url', array(
                'ajax_url' => admin_url('admin-ajax.php')
            ));
        }
    }

    function pro_js()
    {
        $list_widgets_pro = get_option('rkit-widget-pro-options');

        if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
            wp_enqueue_script('rtmprojs', RomeTheme::module_url() . 'widgets/assets/js/rtmwp.js', ['jquery'], RomeTheme::rt_version());
            wp_localize_script('rtmprojs', 'rtmpro', [
                'is_pro' => $this->is_pro(),
                'widgets' => $list_widgets_pro
            ]);
        }
    }

    function save_options()
    {
        $data = $_POST;
        $options = get_option('rkit-widget-options');

        unset($data['action']);

        foreach ($data as $key => $value) {
            $options[$key]['status'] = ($value == "true") ? true : false;
        }

        $update = update_option('rkit-widget-options', $options);

        if ($update) {
            wp_send_json_success('success');
        } else {
            wp_send_json_error('errorrr');
        }
    }

    function is_pro()
    {
        if (class_exists('RomethemePro')) {
            return 'true';
        } else {
            return 'false';
        }
    }
}
