<?php

require RomeTheme::plugin_dir() . 'view/header.php';

$options = get_option('rkit-widget-options');

$headeroptions = array_filter($options, function ($value) {
    return $value['category'] =='header';
});
$rkitoptions = array_filter($options, function ($value) {
    return $value['category'] == 'rkit';
});

$optionsPro = get_option('rkit-widget-pro-options');

?>

<div class="mt-5 m-0 mx-xxl-5 mx-xl-3 font-montserrat">
    <form id="widgets_option">
        <input type="text" name="action" value="save_options" hidden>
        <div class="d-flex flex-row justify-content-between mb-3">
            <div class="d-flex gap-2">
                <button class="btn btn-secondary rounded-0 px-5 py-3" id="disable-all">Disable All</button>
                <button class="btn btn-accent rounded-0 px-5 py-3" id="enable-all">Enable All</button>
            </div>
            <div>
                <button class="btn btn-accent rounded-0 px-5 py-3" id="save-widget-options">Save Changes</button>
            </div>
        </div>
        <div class="mt-4">
            <div class="d-flex w-100 border-bottom py-3 mb-4">
                <h5>Header & Footer</h5>
            </div>
            <div class="row row-cols-xxl-4 row-cols-xl-3">
                <?php foreach ($headeroptions as $h_opt => $value) : ?>
                    <div class="col m-0 p-2">
                        <div class="card rounded-0 w-100 m-0 p-3 border-0">
                            <div class="d-flex flex-row align-items-center justify-content-between">
                                <div class="col-8">
                                    <div class="d-flex flex-row align-items-center gap-3">
                                        <i class="<?php echo esc_attr($value['icon']) ?>" style="font-size:40px;"></i>
                                        <span><?php echo esc_html($value['name']) ?></span>
                                    </div>

                                </div>
                                <div class="col-4">
                                    <div class="d-flex w-100 justify-content-end">
                                        <input name="<?php echo esc_attr($h_opt) ?>" value="false" hidden>
                                        <label class="switch">
                                            <input name="<?php echo esc_attr($h_opt) ?>" class="switch-input" type="checkbox" value="true" <?php echo ($value['status']) ? 'checked' : ''  ?>>
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="mt-4">
            <div class="d-flex w-100 border-bottom py-3 mb-4">
                <h5>General</h5>
            </div>
            <div class="row row-cols-xxl-4 row-cols-xl-3">
                <?php foreach ($rkitoptions as $h_opt => $value) : ?>
                    <div class="col m-0 p-2">
                        <div class="card rounded-0 w-100 m-0 p-3 border-0">
                            <div class="d-flex flex-row align-items-center justify-content-between">
                                <div class="col-8">
                                    <div class="d-flex flex-row align-items-center gap-3">
                                        <i class="<?php echo esc_attr($value['icon']) ?>" style="font-size:40px;"></i>
                                        <span><?php echo esc_html($value['name']) ?></span>
                                    </div>

                                </div>
                                <div class="col-4">
                                    <div class="d-flex w-100 justify-content-end">
                                        <input name="<?php echo esc_attr($h_opt) ?>" value="false" hidden>
                                        <label class="switch">
                                            <input name="<?php echo esc_attr($h_opt) ?>" class="switch-input" type="checkbox" value="true" <?php echo ($value['status']) ? 'checked' : ''  ?>>
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <!-- <div class="mt-4">
            <div class="d-flex w-100 border-bottom py-3 mb-4">
                <h5>Pro Widget</h5>
            </div>
            <div class="row row-cols-xxl-4 row-cols-xl-3">
                <?php foreach ($optionsPro as $h_opt => $value) : ?>
                    <div class="col m-0 p-2">
                        <div class="card rounded-0 w-100 m-0 p-3 border-0">
                            <div class="d-flex flex-row align-items-center justify-content-between">
                                <div class="col-8">
                                    <div class="d-flex flex-row align-items-center gap-3">
                                        <i class="<?php echo esc_attr($value['icon']) ?>" style="font-size:40px;"></i>
                                        <span><?php echo esc_html($value['name']) ?></span>
                                    </div>

                                </div>
                                <div class="col-4">
                                    <div class="d-flex w-100 justify-content-end">
                                        <input name="<?php echo esc_attr($h_opt) ?>" value="false" hidden>
                                        <label class="switch">
                                            <input name="<?php echo esc_attr($h_opt) ?>" class="switch-input" type="checkbox" value="true" <?php echo ($value['status']) ? 'checked' : ''  ?>>
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div> -->
    </form>
</div>