<?php
require RomeTheme::plugin_dir() . 'view/header.php';

?>

<div class="mt-5 font-montserrat m-0 mx-xxl-5 mx-xl-3">
    <div class="d-flex flex-row justify-content-between">
        <div class="d-flex flex-column">
            <h4>Theme Builder</h4>
            <span class="">Transforming Experiences with Our Dynamic and Versatile Theme Builder Solution.</span>
        </div>
        <div>
            <button class="btn btn-accent rounded-0 px-5 py-3" data-bs-toggle="modal" data-bs-target="#exampleModal">Create New Template +</button>
        </div>
    </div>
    <div class="mt-5">
        <ul class="nav sub-nav border-0 mb-3 justify-content-between bg-white" id="pills-tab" role="tablist">
            <ul class="d-flex flex-row align-items-center m-0 p-0">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="tab-all-tab" data-bs-toggle="pill" data-bs-target="#tab-all" type="button" role="tab" aria-controls="tab-all" aria-selected="true">All</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="tab-header-tab" data-bs-toggle="pill" data-bs-target="#tab-header" type="button" role="tab" aria-controls="tab-header" aria-selected="true">Header</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="tab-footer-tab" data-bs-toggle="pill" data-bs-target="#tab-footer" type="button" role="tab" aria-controls="tab-footer" aria-selected="false">Footer</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="tab-singlepost-tab" data-bs-toggle="pill" data-bs-target="#tab-singlepost" type="button" role="tab" aria-controls="tab-singlepost" aria-selected="false">Single Post</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="tab-errorpage-tab" data-bs-toggle="pill" data-bs-target="#tab-errorpage" type="button" role="tab" aria-controls="tab-errorpage" aria-selected="false">404 Page</button>
                </li>
            </ul>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-trash-tab" data-bs-toggle="pill" data-bs-target="#tab-trash" type="button" role="tab" aria-controls="tab-trash" aria-selected="false">Trash</button>
            </li>
        </ul>
        <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="tab-all" role="tabpanel" aria-labelledby="tab-all-tab" tabindex="0">
                <?php
                require RomeTheme::module_dir() . 'themebuilder/views/all.php';
                ?>
            </div>
            <div class="tab-pane fade" id="tab-header" role="tabpanel" aria-labelledby="tab-header-tab" tabindex="0">
                <?php
                require RomeTheme::module_dir() . 'HeaderFooter/views/header.php';
                ?>
            </div>
            <div class="tab-pane fade" id="tab-footer" role="tabpanel" aria-labelledby="tab-footer-tab" tabindex="0">
                <?php
                require RomeTheme::module_dir() . 'HeaderFooter/views/footer.php';
                ?>
            </div>
            <div class="tab-pane fade" id="tab-singlepost" role="tabpanel" aria-labelledby="tab-singlepost-tab" tabindex="0">
                <?php
                if (class_exists('RomethemePro')) {
                    require RomethemePro::module_dir() . '/single/view/single-view.php';
                } else {
                    require RomeTheme::module_dir() . 'themebuilder/views/getproversion.php';
                }
                ?>
            </div>
            <div class="tab-pane fade" id="tab-errorpage" role="tabpanel" aria-labelledby="tab-errorpage-tab" tabindex="0">
                <?php
                if (class_exists('RomethemePro')) {
                    require RomethemePro::module_dir() . '/404/views/404-view.php';
                } else {
                    require RomeTheme::module_dir() . 'themebuilder/views/getproversion.php';
                }
                ?>
            </div>
            <div class="tab-pane fade" id="tab-trash" role="tabpanel" aria-labelledby="tab-trash-tab" tabindex="0">
                <?php
                require RomeTheme::module_dir() . 'themebuilder/views/trash.php';
                ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade font-montserrat" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content rounded-0 border-0 shadow p-0">
            <form id="add-new-post" method="POST">
                <input id="action" name="action" type="text" value="addNewPost" hidden>
                <div class="modal-header px-5">
                    <h5 class="modal-title" id="AddModalLabel"><?php esc_html_e('Create New Template', 'rometheme-for-elementor') ?></h5>
                </div>
                <div class="modal-body d-flex flex-column gap-3 px-5 py-4" style="height:24rem">
                    <ul class="nav nav-underline mb-3" id="pills-tab" role="tablist">
                        <li class="nav-item col" role="presentation">
                            <button class="nav-link active w-100" id="general-tab" data-bs-toggle="pill" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">General</button>
                        </li>
                        <li class="nav-item col" role="presentation">
                            <button class="nav-link w-100" id="condition-tab" data-bs-toggle="pill" data-bs-target="#condition" type="button" role="tab" aria-controls="condition" aria-selected="false">Condition</button>
                        </li>
                    </ul>
                    <div class="tab-content overflow-auto" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab" tabindex="0">
                            <div class="mb-3">
                                <label for="inputTitle" class="form-label fw-semibold">Title</label>
                                <input name="title" type="text" class="form-control py-2" id="inputTitle">
                            </div>
                            <div class="mb-3">
                                <label for="inputType" class="form-label fw-semibold">Type</label>
                                <select name="type" class="form-select py-2 select-type" id="inputType">
                                    <option value="header"><?php esc_html_e('Header', 'rometheme-for-elementor') ?></option>
                                    <option value="footer"><?php esc_html_e('Footer', 'rometheme-for-elementor') ?></option>
                                    <?php if (class_exists('RomethemePro')) : ?>
                                        <option value="404"><?php esc_html_e('404 Page', 'rometheme-for-elementor') ?></option>
                                    <?php else : ?>
                                        <option value="404" disabled><?php esc_html_e('404 Page (Pro Version)', 'rometheme-for-elementor') ?></option>
                                    <?php endif; ?>
                                    <?php if (class_exists('RomethemePro')) : ?>
                                        <option value="single_post"><?php esc_html_e('Single Post', 'rometheme-for-elementor') ?></option>
                                    <?php else : ?>
                                        <option value="single_post" disabled><?php esc_html_e('Single Post (Coming Soon)', 'rometheme-for-elementor') ?></option>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="d-flex flex-column gap-3 option">
                                <div class="d-flex flex-row align-items-center justify-content-between gap-3">
                                    <span class="fw-semibold">Active
                                        <p class="m-0 fst-italic text-secondary fw-normal"><small>Enabling or Disabling Templates</small></p>
                                    </span>
                                    <label class="switch">
                                        <input name="active" id="active" class="switch-input" type="checkbox" value="true" checked>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="condition" role="tabpanel" aria-labelledby="condition-tab" tabindex="0">
                            <div class="condition-container">
                                <div class="d-flex justify-content-between align-content-center gap-5">
                                    <div class="d-flex align-items-center"><small>Set the conditions that determine where your template is used.</small></div>
                                    <div>
                                        <button class="btn btn-accent px-4 py-3 rounded-0 text-nowrap add-condition">Add +</button>
                                    </div>
                                </div>
                                <div class="conditions d-flex flex-column gap-3 py-3">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer px-5 border-0 pb-4 pt-0">
                    <button id="close-btn" type="button" class="col btn btn-secondary py-3 rounded-0 " data-bs-dismiss="modal">Close</button>
                    <button id="add-submit-btn" class="col btn btn-accent py-3 rounded-0 ">Save
                        changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade font-montserrat" id="ModalEdit" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="EditModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content rounded-0">
            <form id="edit_form" method="POST">
                <span id='errfrmMsg' style='margin:0 auto;'></span>
                <input name="id" id="id" type="text" hidden>
                <input id="action" type="text" name="action" value="updatepost" hidden>
                <div class="modal-header border-0 px-5">
                    <h5 class="modal-title" id="EditModalLabel"><?php esc_html_e('Edit Template', 'rometheme-for-elementor') ?></h5>
                </div>
                <div class="modal-body d-flex flex-column gap-3 px-5 py-4" style="height:24rem">
                    <ul class="nav nav-underline mb-3" id="edit-pills-tab" role="tablist">
                        <li class="nav-item col" role="presentation">
                            <button class="nav-link active w-100" id="edit-general-tab" data-bs-toggle="pill" data-bs-target="#edit-general" type="button" role="tab" aria-controls="edit-general" aria-selected="true">General</button>
                        </li>
                        <li class="nav-item col" role="presentation">
                            <button class="nav-link w-100" id="edit-condition-tab" data-bs-toggle="pill" data-bs-target="#edit-condition" type="button" role="tab" aria-controls="edit-condition" aria-selected="false">Condition</button>
                        </li>
                    </ul>
                    <div class="tab-content overflow-auto" id="edit-pills-tabContent">
                        <div class="tab-pane fade show active" id="edit-general" role="tabpanel" aria-labelledby="edit-general-tab" tabindex="0">
                            <div class="mb-3">
                                <label for="inputTitle" class="form-label fw-semibold">Title</label>
                                <input name="title" type="text" class="form-control py-2" id="inputTitle">
                            </div>
                            <div class="mb-3">
                                <label for="inputType" class="form-label fw-semibold">Type</label>
                                <select name="type" class="form-select py-2 select-type" id="inputType">
                                    <option value="header"><?php esc_html_e('Header', 'rometheme-for-elementor') ?></option>
                                    <option value="footer"><?php esc_html_e('Footer', 'rometheme-for-elementor') ?></option>
                                    <?php if (class_exists('RomethemePro')) : ?>
                                        <option value="404"><?php esc_html_e('404 Page', 'rometheme-for-elementor') ?></option>
                                    <?php else : ?>
                                        <option value="404" disabled><?php esc_html_e('404 Page (Pro Version)', 'rometheme-for-elementor') ?></option>
                                    <?php endif; ?>
                                    <?php if (class_exists('RomethemePro')) : ?>
                                        <option value="single_post"><?php esc_html_e('Single Post', 'rometheme-for-elementor') ?></option>
                                    <?php else : ?>
                                        <option value="single_post" disabled><?php esc_html_e('Single Post (Coming Soon)', 'rometheme-for-elementor') ?></option>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="d-flex flex-column gap-3 option">
                                <div class="d-flex flex-row align-items-center justify-content-between gap-3">
                                    <span class="fw-semibold">Active
                                        <p class="m-0 fst-italic text-secondary fw-normal"><small>Enabling or Disabling Templates</small></p>
                                    </span>
                                    <label class="switch">
                                        <input name="active" id="active" class="switch-input" type="checkbox" value="true" checked>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="edit-condition" role="tabpanel" aria-labelledby="edit-condition-tab" tabindex="0">
                            <div class="condition-container">
                                <div class="d-flex justify-content-between align-content-center gap-5">
                                    <div class="d-flex align-items-center"><small>Set the conditions that determine where your template is used.</small></div>
                                    <div>
                                        <button class="btn btn-accent px-4 py-3 rounded-0 text-nowrap add-condition">Add +</button>
                                    </div>
                                </div>
                                <div class="conditions d-flex flex-column gap-3 py-3">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer px-5 border-0 pb-4 pt-0">
                    <button id="close-btn" type="button" class="col btn btn-secondary py-3 rounded-0" data-bs-dismiss="modal">Close</button>
                    <button id="edit-submit-btn" class="col btn btn-accent py-3 rounded-0">Save
                        changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .sub-nav .nav-item {
        margin: 0;
    }

    .sub-nav .nav-item .nav-link {
        border: none;
        color: #727272;
        background-color: transparent;
    }

    .sub-nav .nav-item .nav-link.active {
        font-weight: 600;
        color: #1f2227;
    }
</style>