<?php
if (file_exists(WP_PLUGIN_DIR . '/romethemeform/rometheme-form.php')) {
    $btn['text'] = 'Activate Now';
    $btn['url'] = wp_nonce_url('plugins.php?action=activate&plugin=romethemeform/rometheme-form.php&plugin_status=all&paged=1', 'activate-plugin_romethemeform/rometheme-form.php');
} else {
    $btn['text'] = 'Install Now';
    $btn['url'] = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=romethemeform'), 'install-plugin_romethemeform');
}

require_once(RomeTheme::plugin_dir() . 'view/header.php');      
?>

<div class="container m-0 font-montserrat my-4 p-0 me-3">
    <div class="">
        <div class="d-flex flex-row p-5" style="background-color: #1f2227;">
            <div class="col mx-0">
                <div class="d-flex flex-column justify-content-center h-100">
                    <img src="<?php echo esc_attr(RomeTheme::module_url() . 'Form/rform.png')  ?>" alt="" class="img-fluid p-3" width="300">
                    <div class="d-flex flex-column text-white font-montserrat p-3">
                        <h4 class="text-white fw-semibold lh-base">CREATE & CUSTOMIZE FORM OF YOUR SITE WITH EASE</h4>
                        <ul class="list my-3">
                            <li class="d-flex flex-row align-items-center gap-2">
                               - Create New Form in Elementor Builder
                            </li>
                            <li class="d-flex flex-row align-items-center gap-2">
                               - Send Email Notification and Email Confirmation
                            </li>
                            <li class="d-flex flex-row align-items-center gap-2">
                               - Entries View
                            </li>
                        </ul>
                        <div>
                            <a class="btn btn-outline-accent rounded-0 px-5 py-3" href="<?php echo esc_url($btn['url']) ?>"><?php echo esc_html($btn['text']) ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col p-3">
                <img src="<?php echo esc_attr(RomeTheme::module_url() . 'Form/romethemeform1a.png')  ?>" alt="" class="img-fluid">
            </div>
        </div>
    </div>
</div>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;500&display=swap');
    @import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

    .divider {
        position: relative;
        background-color: #33e4c0;
        height: 35px;
        width: 2px;
    }

    .font-space {
        font-family: 'Space Grotesk', sans-serif;
    }

    .font-montserrat {
        font-family: 'Montserrat', sans-serif;
    }

    .accent-color {
        color: #33e4c0;
    }

    body {
        background-color: #f0f0f1;
    }

    ul.list {
        margin: 0;
        padding: 0;
    }
</style>